# Circle Web Smart Card Service Frontend

The frontend of the Circle Web Smart Card Service is a demo website that provides a user interface to interact with smart card readers via the backend service. The website communicates with the backend over a WebSocket connection (`ws://127.0.0.1:55002`) to list available readers, connect to a reader, send APDU commands, and disconnect.

## Prerequisites

- A web browser

## Running the Web Application

Before running the demo website, ensure The Circle Web Smart Card Service is installed and running on your system.

1. **Start a local web server**:
   Navigate to the project directory and run by using python:

   python -m http.server

2. **Open the application in your browser**:
   Open your web browser and go to `http://localhost:8000`.

## File Structure

- `index.html`: The main HTML file that defines the structure of the demo website.
- `styles.css`: The CSS file for styling the demo website.
- `CircleWebDemo.js`: A demo script that uses JavaScript library`SmartCardReader.js` to interact with the backend and update the UI with reader information and APDU responses.
- `SmartCardReader.js`: A JavaScript library that handles WebSocket communication with the backend service.

## Troubleshooting

- **CORS Issues**: If you encounter issues with CORS, ensure you are running a local server as described above.
- **File Paths**: Ensure that the paths to your CSS and JavaScript files are correct.


## Contact

Website: http://www.abcircle.com
E-mail: info@abcircle.com

## Copyright

Copyright (c) 2020-2025, AB Circle Limited. No part of this readme text may be reproduced or transmitted in any from without the expressed, written permission of AB Circle.

Notice
Due to rapid change in technology, some of specifications mentioned in this publication are subject to change without notice. Information furnished is believed to be accurate and reliable. AB Circle assumes no responsibility for any errors or omissions, which may appear in this document.